<?php
/**
 * Library Assets class
 *
 * @package InventSlider
 * @version 1.0.8
 */
namespace DynamicLayers\InventSlider\Classes\Library;

defined( 'ABSPATH' ) || die();

class Assets {
    /**
     * Init
     */
    function __construct() {
        add_action('elementor/editor/after_enqueue_scripts', [$this, 'el_editor_scripts']);
    }

    /**
     * Elementor Editor Scripts
     *
     * @return void
     */
    public function el_editor_scripts() {

        wp_enqueue_style(
			'invent-slider-templates-library',
			INVENT_SLIDER_ASSETS . '/admin/css/template-library.min.css',
			[ 'elementor-editor' ],
			INVENT_SLIDER_VERSION
		);

		wp_enqueue_script(
			'invent-slider-templates-library',
			INVENT_SLIDER_ASSETS . '/admin/js/template-library.min.js',
			[ 'jquery-hover-intent' ],
			INVENT_SLIDER_VERSION,
			true
		);

        $openLibraryButton = INVENT_SLIDER_ASSETS . '/img/library-btn.svg';

        $data = [
            'openLibraryButton' => esc_url($openLibraryButton),
			'i18n' => [
				'promotionDialogHeader'     => esc_html__('%s Widget', 'invent-slider'),
				'promotionDialogMessage'    => esc_html__('Use %s widget with other exclusive pro widgets and 100% unique features to extend your toolbox and build sites faster and better.', 'invent-slider'),
				'promotionDialogBtnTxt'    => esc_html__('Upgrade Now', 'invent-slider'),
				'templatesEmptyTitle'       => esc_html__('No Templates Found', 'invent-slider'),
				'templatesEmptyMessage'     => esc_html__('Try different category or sync for new templates.', 'invent-slider'),
				'templatesNoResultsTitle'   => esc_html__('No Results Found', 'invent-slider'),
				'templatesNoResultsMessage' => esc_html__('Please make sure your search is spelled correctly or try a different words.', 'invent-slider'),
			],
		];

		wp_localize_script(
			'invent-slider-templates-library',
			'InventSliderEditorData',
			$data
		);
    }

}