<?php
/**
 * Library Manager class
 *
 * @package InventSlider
 * @version 1.0.8
 */
namespace DynamicLayers\InventSlider\Classes\Library;

use Elementor\Core\Common\Modules\Ajax\Module as Ajax;
use DynamicLayers\InventSlider\Classes\Library\Source;
use DynamicLayers\InventSlider\Classes\Helper;

defined( 'ABSPATH' ) || die();

class Manager {

    protected static $source = null;

	/**
	 * Print template views in editor footer
	 * @return void
	 */
    public static function print_template_views() {
		include_once INVENT_SLIDER_DIR_PATH . '/templates/templates.php';
	}

    /**
	 * Get Source instance
	 *
	 * @return Source
	 */
	public static function get_source() {
		if ( is_null( self::$source ) ) {
			self::$source = new Source();
		}

		return self::$source;
	}

	/**
	 * Register AJAX actions
	 * @param Ajax $ajax
	 * @return void
	 */
    public static function register_ajax_actions( Ajax $ajax ) {
		$ajax->register_ajax_action( 'get_invent_slider_library_data', function( $data ) {
			if ( ! current_user_can( 'edit_posts' ) ) {
				throw new \Exception( 'Access Denied' );
			}

			if ( ! empty( $data['editor_post_id'] ) ) {
				$editor_post_id = absint( $data['editor_post_id'] );

				if ( ! get_post( $editor_post_id ) ) {
					throw new \Exception( __( 'Post not found.', 'invent-slider' ) );
				}

				Helper::elementor_instance()->db->switch_to_post( $editor_post_id );
			}

			$result = self::get_library_data( $data );

			return $result;
		} );

		$ajax->register_ajax_action( 'get_invent_slider_template_data', function( $data ) {
			if ( ! current_user_can( 'edit_posts' ) ) {
				throw new \Exception( 'Access Denied' );
			}

			if ( ! empty( $data['editor_post_id'] ) ) {
				$editor_post_id = absint( $data['editor_post_id'] );

				if ( ! get_post( $editor_post_id ) ) {
					throw new \Exception( __( 'Post not found', 'invent-slider' ) );
				}

				Helper::elementor_instance()->db->switch_to_post( $editor_post_id );
			}

			if ( empty( $data['template_id'] ) ) {
				throw new \Exception( __( 'Template id missing', 'invent-slider' ) );
			}

			$result = self::get_template_data( $data );

			return $result;
		} );

		// 🧹 Clear transient cache
		$ajax->register_ajax_action( 'clear_invent_slider_cache', function( $data ) {
			if ( ! current_user_can( 'edit_posts' ) ) {
				throw new \Exception( 'Access Denied' );
			}

			delete_transient( 'invent_library_cache' );

			return [ 'success' => true, 'message' => __( 'Library cache cleared', 'invent-slider' ) ];
		});
	}

	/**
	 * Get template data
	 * @param array $args
	 * @return array
	 */
    public static function get_template_data( array $args ) {
		$source = self::get_source();
		$data = $source->get_data( $args );
		return $data;
	}

    /**
	 * Get library data from cache or remote
	 *
	 * type_tags has been added in version 2.15.0
	 *
	 * @param array $args
	 *
	 * @return array
	 */
	public static function get_library_data( array $args ) {
		$source = self::get_source();

		if ( ! empty( $args['sync'] ) ) {
			Source::get_library_data( true );
		}

		return [
			'templates' => $source->get_items(),
			'tags'      => $source->get_tags(),
			'type_tags' => $source->get_type_tags(),
		];
	}

}