<?php
/**
 * Widgets class
 *
 * @package InventSlider
 */
namespace DynamicLayers\InventSlider\Classes;

use \Elementor\Plugin as Plugin;

defined( 'ABSPATH' ) || die();

class Widgets {

    /**
     * Initialize
     */
    public function __construct() {
        add_action( 'elementor/widgets/widgets_registered', [ $this, 'register'] );
    }

    public function get_widgets() {
        return [
            'Slider'
        ];
    }

    /**
     * Widgets Register
     *
     * @return void
     */
    public function register() {
        $widgets = $this->get_widgets();
        if ( $widgets ) {
            foreach ($widgets as $widget){
                $widget_init = '\DynamicLayers\InventSlider\Widgets\\'. $widget .'\\Widget';
                Plugin::instance()->widgets_manager->register( new $widget_init );
            }
        }
    }
}
