<?php
/**
 * Template library templates
 */

defined( 'ABSPATH' ) || exit;

?>
<script type="text/template" id="tmpl-inventSlider__header-logo">
    <span class="inventSlider__logo-wrap">
		<img class="inventSlider__logo-image" src="<?php echo INVENT_SLIDER_ASSETS . '/img/library-btn.svg'; ?>" alt="<?php esc_attr_e( 'Invent Slider', 'invent-slider' ); ?>" />
	</span>
    <span class="inventSlider__logo-title">{{{ title }}}</span>
</script>

<script type="text/template" id="tmpl-inventSlider__header-back">
	<i class="eicon-" aria-hidden="true"></i>
	<span><?php echo __( 'Back to Library', 'invent-slider' ); ?></span>
</script>

<script type="text/template" id="tmpl-inventSlider__header-menu">
	<# _.each( tabs, function( args, tab ) { var activeClass = args.active ? 'elementor-active' : ''; #>
		<div class="elementor-component-tab elementor-template-library-menu-item {{activeClass}}" data-tab="{{{ tab }}}">{{{ args.title }}}</div>
	<# } ); #>
</script>

<script type="text/template" id="tmpl-inventSlider__header-menu-responsive">
	<div class="elementor-component-tab inventSlider__responsive-menu-item elementor-active" data-tab="desktop">
		<i class="eicon-device-desktop" aria-hidden="true" title="<?php esc_attr_e( 'Desktop view', 'invent-slider' ); ?>"></i>
		<span class="elementor-screen-only"><?php esc_html_e( 'Desktop view', 'invent-slider' ); ?></span>
	</div>
	<div class="elementor-component-tab inventSlider__responsive-menu-item" data-tab="tab">
		<i class="eicon-device-tablet" aria-hidden="true" title="<?php esc_attr_e( 'Tab view', 'invent-slider' ); ?>"></i>
		<span class="elementor-screen-only"><?php esc_html_e( 'Tab view', 'invent-slider' ); ?></span>
	</div>
	<div class="elementor-component-tab inventSlider__responsive-menu-item" data-tab="mobile">
		<i class="eicon-device-mobile" aria-hidden="true" title="<?php esc_attr_e( 'Mobile view', 'invent-slider' ); ?>"></i>
		<span class="elementor-screen-only"><?php esc_html_e( 'Mobile view', 'invent-slider' ); ?></span>
	</div>
</script>

<script type="text/template" id="tmpl-inventSlider__header-actions">
	<div id="inventSlider__header-sync" class="elementor-templates-modal__header__item">
		<i class="eicon-sync" aria-hidden="true" title="<?php esc_attr_e( 'Sync Library', 'invent-slider' ); ?>"></i>
		<span class="elementor-screen-only"><?php esc_html_e( 'Sync Library', 'invent-slider' ); ?></span>
	</div>
</script>

<script type="text/template" id="tmpl-inventSlider__preview">
    <iframe></iframe>
</script>

<script type="text/template" id="tmpl-inventSlider__header-insert">
	<div id="elementor-template-library-header-preview-insert-wrapper" class="elementor-templates-modal__header__item">
		{{{ inventSlider.library.getModal().getTemplateActionButton( obj ) }}}
	</div>
</script>

<script type="text/template" id="tmpl-inventSlider__insert-button">
	<a class="elementor-template-library-template-action elementor-button inventSlider__insert-button">
		<i class="eicon-file-download" aria-hidden="true"></i>
		<span class="elementor-button-title"><?php esc_html_e( 'Insert', 'invent-slider' ); ?></span>
	</a>
</script>

<script type="text/template" id="tmpl-inventSlider__pro-button">
	<a class="elementor-template-library-template-action elementor-button inventSlider__pro-button" href="https://addons.dynamiclayers.net/invent-slider/" target="_blank">
		<i class="eicon-external-link-square" aria-hidden="true"></i>
		<span class="elementor-button-title"><?php esc_html_e( 'Get Pro', 'invent-slider' ); ?></span>
	</a>
</script>

<script type="text/template" id="tmpl-inventSlider__loading">
	<div class="elementor-loader-wrapper">
		<div class="elementor-loader">
			<div class="elementor-loader-boxes">
				<div class="elementor-loader-box"></div>
				<div class="elementor-loader-box"></div>
				<div class="elementor-loader-box"></div>
				<div class="elementor-loader-box"></div>
			</div>
		</div>
		<div class="elementor-loading-title"><?php esc_html_e( 'Loading', 'invent-slider' ); ?></div>
	</div>
</script>

<script type="text/template" id="tmpl-inventSlider__templates">
	<div id="inventSlider__toolbar">
		<div id="inventSlider__toolbar-filter" class="inventSlider__toolbar-filter">
			<# if (inventSlider.library.getTypeTags()) { var selectedTag = inventSlider.library.getFilter( 'tags' ); #>
				<# if ( selectedTag ) { #>
				<span class="inventSlider__filter-btn">{{{ inventSlider.library.getTags()[selectedTag] }}} <i class="eicon-caret-right"></i></span>
				<# } else { #>
				<span class="inventSlider__filter-btn"><?php esc_html_e( 'Filter', 'invent-slider' ); ?> <i class="eicon-caret-right"></i></span>
				<# } #>
				<ul id="inventSlider__filter-tags" class="inventSlider__filter-tags">
					<li data-tag="">All</li>
					<# _.each(inventSlider.library.getTypeTags(), function(slug) {
						var selected = selectedTag === slug ? 'active' : '';
						#>
						<li data-tag="{{ slug }}" class="{{ selected }}">{{{ inventSlider.library.getTags()[slug] }}}</li>
					<# } ); #>
				</ul>
			<# } #>
		</div>
		<div id="inventSlider__toolbar-counter"></div>
		<div id="inventSlider__toolbar-search">
			<label for="inventSlider__search" class="elementor-screen-only"><?php esc_html_e( 'Search Templates:', 'invent-slider' ); ?></label>
			<input id="inventSlider__search" placeholder="<?php esc_attr_e( 'Search', 'invent-slider' ); ?>">
			<i class="eicon-search"></i>
		</div>
	</div>

	<div class="inventSlider__templates-window">
		<div id="inventSlider__templates-list"></div>
	</div>
</script>

<script type="text/template" id="tmpl-inventSlider__template">
	<div class="inventSlider__template-body" id="inventSliderTemplate-{{ template_id }}">
		<div class="inventSlider__template-preview">
			<i class="eicon-zoom-in-bold" aria-hidden="true"></i>
		</div>
		<img class="inventSlider__template-thumbnail" src="{{ thumbnail }}">
		<# if ( obj.isPro ) { #>
		<span class="inventSlider__template-badge"><?php esc_html_e( 'Pro', 'invent-slider' ); ?></span>
		<# } #>
	</div>
	<div class="inventSlider__template-footer">
		{{{ inventSlider.library.getModal().getTemplateActionButton( obj ) }}}
		<a href="#" class="elementor-button inventSlider__preview-button">
			<i class="eicon-device-desktop" aria-hidden="true"></i>
			<?php esc_html_e( 'Preview', 'invent-slider' ); ?>
		</a>
	</div>
</script>

<script type="text/template" id="tmpl-inventSlider__empty">
	<div class="elementor-template-library-blank-icon">
		<img src="<?php echo ELEMENTOR_ASSETS_URL . 'images/no-search-results.svg'; ?>" class="elementor-template-library-no-results" />
	</div>
	<div class="elementor-template-library-blank-title"></div>
	<div class="elementor-template-library-blank-message"></div>
	<div class="elementor-template-library-blank-footer">
		<?php esc_html_e( 'Want to learn more about the Invent Slider Library?', 'invent-slider' ); ?>
		<a class="elementor-template-library-blank-footer-link" href="https://addons.dynamiclayers.net/doc/invent-slider/" target="_blank"><?php echo __( 'Click here', 'invent-slider' ); ?></a>
	</div>
</script>
