<?php
/**
 * @var $current_user
 */

stm_lms_register_style( 'create_announcement' );
stm_lms_register_script( 'create_announcement' );

wp_localize_script(
	'stm-lms-create_announcement',
	'create_announcement_data',
	array(
		'loading_your_courses'          => esc_html__( 'Loading your courses', 'masterstudy-lms-learning-management-system-pro' ),
		'unable_to_load_courses'        => esc_html__( 'Unable to load courses', 'masterstudy-lms-learning-management-system-pro' ),
		'unable_to_create_announcement' => esc_html__( 'Unable to create announcement', 'masterstudy-lms-learning-management-system-pro' ),
	)
)
?>
<div class="stm_lms_create_announcement" id="stm_lms_create_announcement">
	<div class="row">
		<div class="col-md-12">
			<div class="form-group">
				<label class="heading_font"><?php esc_html_e( 'Choose Course', 'masterstudy-lms-learning-management-system-pro' ); ?></label>
				<select class="disable-select form-control stm_lms_create_announcement__course_select">
					<option value=""><?php esc_html_e( '- Choose Course for Announcement -', 'masterstudy-lms-learning-management-system-pro' ); ?></option>
				</select>
			</div>
		</div>

		<div class="col-md-12">
			<div class="form-group">
				<label class="heading_font"><?php esc_html_e( 'Message for Course Students', 'masterstudy-lms-learning-management-system-pro' ); ?></label>
				<textarea class="stm_lms_create_announcement__message-input" placeholder="<?php esc_attr_e( 'Enter message for students', 'masterstudy-lms-learning-management-system-pro' ); ?>"></textarea>
			</div>
		</div>
	</div>

	<div class="row">
		<div class="col-md-12">
			<button class="btn btn-default create-announcement-btn">
				<span><?php esc_html_e( 'Create Announcement', 'masterstudy-lms-learning-management-system-pro' ); ?></span>
			</button>
		</div>
		<div class="col-md-12">
			<div class="stm-lms-message stm_lms_create_announcement__response-msg"></div>
		</div>
	</div>
</div>
