<?php
stm_lms_register_style( 'datepicker' );
stm_lms_register_style( 'account/v1/statistic' );
wp_enqueue_script( 'moment.min', STM_LMS_URL . '/assets/vendors/moment.min.js', '', STM_LMS_PRO_VERSION, true );
wp_enqueue_script( 'chart.min', STM_LMS_URL . '/assets/vendors/chart.min.js', '', STM_LMS_PRO_VERSION, true );

$user = new \stmLms\Classes\Models\StmUser( get_current_user_id() );

$data                 = array( 'author_id' => $user->ID );
$data['paypal_email'] = get_user_meta( $user->ID, 'stm_lms_paypal_email', true );

$data['currency_symbol'] = STM_LMS_Options::get_option( 'currency_symbol', '$' );

$user_courses = $user->get_courses();
$date_end     = new DateTime();
$date_start   = new DateTime();
$date_start->modify( 'first day of this month' )->setTime( 0, 0, 0 );
date_sub( $date_start, date_interval_create_from_date_string( '5 months' ) );


$date_start_n          = clone $date_start;
$courses_earnings_date = array();
$labels_earnings       = array();
$datasets_earnings     = array();

for ( $i = 0; $i < 6; $i++ ) {
	$labels_earnings[]       = $date_start_n->format( 'F' );
	$courses_earnings_date[] = $date_start_n->format( 'd-m-Y' );
	date_add( $date_start_n, date_interval_create_from_date_string( '1 months' ) );
}

foreach ( $user_courses as $k => $user_course ) {
	$courses = \stmLms\Classes\Models\StmStatistics::get_course_statisticas( $date_start->format( 'Y-m-d' ), $date_end->format( 'Y-m-d' ), $user->ID, $user_course->ID );

	$datasets_data = array();
	foreach ( $courses as $course ) {

		foreach ( $courses_earnings_date as $_date ) {
			$_date       = new DateTime( $_date );
			$m           = (int) $_date->format( 'm' );
			$_date       = $_date->format( 'm-Y' );
			$course_date = new DateTime( $course['date'] );

			if ( ! isset( $datasets_data[ $m ] ) ) {
				$datasets_data[ $m ] = 0;
			}

			if ( $course_date->format( 'm-Y' ) === $_date ) {
				$datasets_data[ $m ] += $course['amount'];
			}
		}


		$datasets_earnings[ $k ] = array(
			'label'           => $course['title'],
			'backgroundColor' => $course['backgroundColor'],
			'data'            => array_values( $datasets_data ),
		);
	}
}

$data['labels_earnings']   = $labels_earnings;
$data['datasets_earnings'] = $datasets_earnings;

$course_sales_statisticas  = \stmLms\Classes\Models\StmStatistics::get_course_sales_statisticas( $user->ID );
$data['sales_statisticas'] = $course_sales_statisticas;

stm_lms_register_script(
	'account-statistics',
	array(
		'jquery',
		'moment.min',
		'masterstudy-charts-helpers',
		'masterstudy-chartjs-library',
		'masterstudy-api-provider',
		'masterstudy-datepicker-helpers',
		'masterstudy-date-helpers',
	),
);

wp_localize_script(
	'stm-lms-account-statistics',
	'masterstudy_lms_statistics_data',
	array(

		'translations' => array(
			'sales_text'    => esc_html__( 'My Sales', 'masterstudy-lms-learning-management-system-pro' ),
			'earnings_text' => esc_html__( 'Earnings', 'masterstudy-lms-learning-management-system-pro' ),
			'yes'           => esc_html__( 'Yes', 'masterstudy-lms-learning-management-system-pro' ),
			'no'            => esc_html__( 'No', 'masterstudy-lms-learning-management-system-pro' ),
		),
		'data'         => $data,
		'stats_data'   => array(
			'custom_period' => __( 'Date range', 'masterstudy-lms-learning-management-system' ),
			'locale'        => masterstudy_get_locale_info(),
		),
	)
);

wp_localize_script(
	'masterstudy-api-provider',
	'api_data',
	array(
		'rest_url' => esc_url_raw( rest_url( '' ) ),
		'nonce'    => wp_create_nonce( 'wp_rest' ),
	)
);

?>

<?php do_action( 'stm_lms_admin_after_wrapper_start', STM_LMS_User::get_current_user() ); ?>

<div id="stm-account-statistics">
	<div class="stm-lms-user-quizzes">
		<div class="row">
			<div class="col-xs-12">
				<div class="stm-lms-message stm-lms-statistics__paypal-email-response hidden"></div>
			</div>

			<div class="col-xs-12 col-sm-6">
				<h2 class="stat-title"><?php esc_html_e( 'Statistics', 'masterstudy-lms-learning-management-system-pro' ); ?></h2>
			</div>
			<div class="col-xs-12 col-sm-6">
				<div class="stat-actions">
					<div class="form-group">
						<input type="text" class="stm-account-statistics__email-input form-control"
								placeholder="<?php esc_html_e( 'Paypal Email', 'masterstudy-lms-learning-management-system-pro' ); ?>">
					</div>
					<button class="btn btn-default payout-save-email"
						<span><?php esc_html_e( 'Save', 'masterstudy-lms-learning-management-system-pro' ); ?></span>
					</button>
				</div>
			</div>
		</div>

		<div class="multiseparator"></div>

		<div class="stm-account-statistics__charts row hidden">
			<div class="col-xs-12 col-sm-12">
				<canvas id="line_chart_id" height="475" class="statistics-chart-class"></canvas>
			</div>
			<div class="col-xs-12 col-sm-12">
				<canvas id="pie_chart_id" height="475" class="statistics-chart-class"></canvas>
			</div>
		</div>

		<div class="stm-lms-user-quiz__head heading_font stm-account-statistics__table-filters hidden">
			<div class="stm-account-statistics__filters-container">
				<div class="stm-lms-user-quiz__head_title">
					<select name="category" class="form-control disable-select"></select>
				</div>
				<div class="stm-lms-user-quiz__head_title">
					<div class="stm-datepicker">
						<?php STM_LMS_Templates::show_lms_template( 'components/analytics/date-field' ); ?>
						<?php STM_LMS_Templates::show_lms_template( 'components/analytics/datepicker-modal', array( 'id' => 'stm-account-statistics' ) ); ?>
						</date-picker>
					</div>
				</div>
			</div>
			<div class="stm-lms-user-quiz__head_title text-right stm-account-statistics__total-price">
				<h5 class="p-t-15"><?php esc_html_e( 'Total price', 'masterstudy-lms-learning-management-system-pro' ); ?>: <strong></strong></h5>
			</div>
			<div class="stm-lms-user-quiz__head_title text-right stm-account-statistics__total-count">
				<h5 class="p-t-15"><?php esc_html_e( 'Total count', 'masterstudy-lms-learning-management-system-pro' ); ?>: <strong></strong></h5>
			</div>
		</div>

	</div>
	<table class="table table-striped stm-account-statistics__orders-table hidden">
		<thead>
		<tr>
			<th>#</th>
			<th><?php esc_html_e( 'Course', 'masterstudy-lms-learning-management-system-pro' ); ?></th>
			<th><?php esc_html_e( 'Qty', 'masterstudy-lms-learning-management-system-pro' ); ?></th>
			<th><?php esc_html_e( 'Total Price', 'masterstudy-lms-learning-management-system-pro' ); ?>
				<?php echo esc_attr( $data['currency_symbol'] ); ?>
			</th>
			<th><?php esc_html_e( 'Payout', 'masterstudy-lms-learning-management-system-pro' ); ?></th>
			<th><?php esc_html_e( 'Created', 'masterstudy-lms-learning-management-system-pro' ); ?></th>
		</tr>
		</thead>
		<tbody>
		</tbody>
	</table>

	<div class="text-center p-b-30 stm-account-statistics__load-more-container">
		<button class="btn btn-default payout-save-email hidden">
			<span><?php esc_html_e( 'Load more', 'masterstudy-lms-learning-management-system-pro' ); ?></span></button>
	</div>
	<button class="btn btn-default payout-save-email stm-account-statistics__clear-filter hidden"><?php esc_html_e( 'Clear Filter', 'masterstudy-lms-learning-management-system-pro' ); ?>
	</button>
	<h3 class="p-t-30 stm-account-statistics__no-items-text"><?php esc_html_e( 'Statistics have not yet appeared.', 'masterstudy-lms-learning-management-system-pro' ); ?></h3>
</div>
