<?php

namespace MasterStudy\Lms\Pro\addons\certificate_builder;

class DemoImporter {
	const DEMOS = array(
		'demo-1'  => array(
			'title'       => 'Demo 1',
			'orientation' => 'landscape',
			'thumbnail'   => '/assets/img/certificate-builder/demo-1.png',
		),
		'demo-2'  => array(
			'title'       => 'Demo 2',
			'orientation' => 'portrait',
			'thumbnail'   => '/assets/img/certificate-builder/demo-2.png',
		),
		'demo-3'  => array(
			'title'       => 'Demo 3',
			'orientation' => 'landscape',
			'thumbnail'   => '/assets/img/certificate-builder/demo-3.jpg',
		),
		'demo-4'  => array(
			'title'       => 'Demo 4',
			'orientation' => 'landscape',
			'thumbnail'   => '/assets/img/certificate-builder/demo-4.jpg',
		),
		'demo-5'  => array(
			'title'       => 'Demo 5',
			'orientation' => 'landscape',
			'thumbnail'   => '/assets/img/certificate-builder/demo-5.jpg',
		),
		'demo-6'  => array(
			'title'       => 'Demo 6',
			'orientation' => 'landscape',
			'thumbnail'   => '/assets/img/certificate-builder/demo-6.jpg',
		),
		'demo-7'  => array(
			'title'       => 'Demo 7',
			'orientation' => 'landscape',
			'thumbnail'   => '/assets/img/certificate-builder/demo-7.jpg',
		),
		'demo-8'  => array(
			'title'       => 'Demo 8',
			'orientation' => 'landscape',
			'thumbnail'   => '/assets/img/certificate-builder/demo-8.jpg',
		),
		'demo-9'  => array(
			'title'       => 'Demo 9',
			'orientation' => 'landscape',
			'thumbnail'   => '/assets/img/certificate-builder/demo-9.jpg',
		),
		'demo-10' => array(
			'title'       => 'Demo 10',
			'orientation' => 'portrait',
			'thumbnail'   => '/assets/img/certificate-builder/demo-10.jpg',
		),
	);

	public function import(): void {
		$is_imported = get_option( 'stm_lms_certificates_imported', '' );

		if ( ! empty( $is_imported ) ) {
			return;
		}

		update_option( 'stm_lms_certificates_imported', '1' );
		update_option( 'stm_lms_new_certificates_imported', '1' ); // TODO: remove after next major release (v4.5.0)

		$certificate_ids     = $this->create_demo_certificates();
		$default_certificate = CertificateRepository::get_default_certificate();

		if ( empty( $default_certificate ) && ! empty( $certificate_ids[0] ) ) {
			CertificateRepository::set_default_certificate( $certificate_ids[0] );
		}
	}

	public function create_demo_certificates( array $exclude_demos = array() ): array {
		$repository      = new CertificateRepository();
		$logo_urls       = $this->upload_logos();
		$certificate_ids = array();

		$demo_fields = array(
			'demo-1'  => '[{"type":"image","content":"' . $logo_urls['logo_gray'] . '","x":"411","y":"58","w":"79","h":"72","styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"left","textDecoration":"","fontStyle":"","fontWeight":""},"imageId":"1404"},{"type":"text","content":"CERTIFICATE","x":"0","y":"149","w":"900","h":"71","styles":{"fontSize":"60px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"center","textDecoration":"","fontStyle":"","fontWeight":"true"}},{"type":"student_name","content":"-Student Name-","x":"0","y":"242","w":"900","h":"50","styles":{"fontSize":"28px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"center","textDecoration":"","fontStyle":"","fontWeight":"true"}},{"type":"course_name","content":"-Course Name-","x":"203","y":"380","w":"494","h":"50","styles":{"fontSize":"20px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"center","textDecoration":"","fontStyle":"","fontWeight":""}},{"type":"text","content":"Lorem ipsum dolor sit amet,  tempor incididunt ut labore et dolore. Successfully completed courses in:","x":"194","y":"312","w":"512","h":"50","styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"center","textDecoration":"","fontStyle":"","fontWeight":""}},{"type":"text","content":"Instructor","x":"201","y":"482","w":"150","h":"27","styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"left","textDecoration":"","fontStyle":"","fontWeight":""}},{"type":"author","content":"-Instructor-","x":"201","y":"464","w":"250","h":"23","styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"left","textDecoration":"","fontStyle":"","fontWeight":"true"}},{"type":"image","content":"' . $logo_urls['sign'] . '","x":"497","y":"430","w":"107","h":"107","styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"left","textDecoration":"","fontStyle":"","fontWeight":""},"imageId":"1405"}]',
			'demo-2'  => '[{"type":"text","content":"  CERTIFICATE","x":-9,"y":336,"w":591,"h":83,"styles":{"fontSize":"60px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"center","textDecoration":"","fontStyle":"","fontWeight":"true"},"classes":"left-align"},{"type":"image","content":"' . $logo_urls['logo_gray'] . '","x":258,"y":235,"w":"90","h":"83","styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"left","textDecoration":"","fontStyle":"","fontWeight":""},"imageId":"1404","classes":""},{"type":"student_name","content":"-Student Name-","x":-9,"y":442,"w":"591","h":"50","styles":{"fontSize":"32px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"center","textDecoration":"","fontStyle":"","fontWeight":""},"classes":"left-align"},{"type":"text","content":"Lorem ipsum dolor sit amet,  tempor incididunt ut labore et dolore. Successfully completed courses in:","x":88,"y":513,"w":"430","h":"50","styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"center","textDecoration":"","fontStyle":"","fontWeight":""},"classes":""},{"type":"course_name","content":"-Course Name-","x":150,"y":587,"w":"286","h":"50","styles":{"fontSize":"24px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"center","textDecoration":"","fontStyle":"","fontWeight":""},"classes":""},{"type":"text","content":"Istructor","x":132,"y":721,"w":"150","h":"33","styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"left","textDecoration":"","fontStyle":"","fontWeight":""},"classes":""},{"type":"image","content":"' . $logo_urls['sign'] . '","x":363,"y":659,"w":"132","h":"138","styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"left","textDecoration":"","fontStyle":"","fontWeight":""},"imageId":"1405","classes":""},{"type":"author","content":"-Instructor-","x":130,"y":693,"w":150,"h":28,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"left","fontStyle":false,"fontWeight":"400"},"classes":""}]',
			'demo-3'  => '[{"type":"text","content":"CERTIFICATE","x":"0","y":"133","w":"900","h":"52","styles":{"fontSize":"40px","fontFamily":"Montserrat","color":{"hsl":{"h":"183.63636363636363","s":"0.23741007194244604","l":"0.27254901960784317","a":"1"},"hex":"#355456","rgba":{"r":"53","g":"84","b":"86","a":"1"},"hsv":{"h":"183.63636363636363","s":"0.38372093023255816","v":"0.33725490196078434","a":"1"},"oldHue":"183.63636363636363","source":"hex","a":"1"},"textAlign":"center","textDecoration":"","fontStyle":"","fontWeight":true},"classes":""},{"type":"student_name","content":"-Student Name-","x":"0","y":"245","w":"900","h":"43","styles":{"fontSize":"28px","fontFamily":"Montserrat","color":{"hsl":{"h":"183.63636363636363","s":"0.23741007194244604","l":"0.27254901960784317","a":"1"},"hex":"#355456","rgba":{"r":"53","g":"84","b":"86","a":"1"},"hsv":{"h":"183.63636363636363","s":"0.38372093023255816","v":"0.33725490196078434","a":"1"},"oldHue":"183.63636363636363","source":"hex","a":"1"},"textAlign":"center","textDecoration":"","fontStyle":"","fontWeight":"true"},"classes":""},{"type":"course_name","content":"-Course Name-","x":"0","y":"357","w":"900","h":"50","styles":{"fontSize":"20px","fontFamily":"Montserrat","color":{"hsl":{"h":"183.63636363636363","s":"0.23741007194244604","l":"0.27254901960784317","a":"1"},"hex":"#355456","rgba":{"r":"53","g":"84","b":"86","a":"1"},"hsv":{"h":"183.63636363636363","s":"0.38372093023255816","v":"0.33725490196078434","a":"1"},"oldHue":"183.63636363636363","source":"hex","a":"1"},"textAlign":"center","textDecoration":"","fontStyle":"","fontWeight":"true"},"classes":""},{"type":"text","content":"Lorem ipsum dolor sit amet,  tempor incididunt ut labore et dolore. Successfully completed courses in:","x":194,"y":300,"w":"512","h":"50","styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":"183.63636363636363","s":"0.23741007194244604","l":"0.27254901960784317","a":"1"},"hex":"#355456","rgba":{"r":"53","g":"84","b":"86","a":"1"},"hsv":{"h":"183.63636363636363","s":"0.38372093023255816","v":"0.33725490196078434","a":"1"},"oldHue":"183.63636363636363","source":"hex","a":"1"},"textAlign":"center","textDecoration":"","fontStyle":"","fontWeight":""},"classes":""},{"type":"text","content":"Instructor","x":"221","y":"424","w":"150","h":"27","styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"left","textDecoration":"","fontStyle":"","fontWeight":""},"classes":""},{"type":"author","content":"-Instructor-","x":"221","y":"451","w":484,"h":23,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":"183.63636363636363","s":"0.23741007194244604","l":"0.27254901960784317","a":"1"},"hex":"#355456","rgba":{"r":"53","g":"84","b":"86","a":"1"},"hsv":{"h":"183.63636363636363","s":"0.38372093023255816","v":"0.33725490196078434","a":"1"},"oldHue":"183.63636363636363","source":"hex","a":"1"},"textAlign":"left","textDecoration":"","fontStyle":"","fontWeight":"true"},"classes":""},{"type":"image","content":"' . $logo_urls['sign'] . '","x":"579","y":"390","w":"107","h":"107","styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"left","textDecoration":"","fontStyle":"","fontWeight":""},"imageId":"1405","classes":"right-align"},{"type":"code","content":"-Certificate code-","x":546,"y":505,"w":260,"h":29,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":"183.63636363636363","s":"0.23741007194244604","l":"0.27254901960784317","a":"1"},"hex":"#355456","rgba":{"r":"53","g":"84","b":"86","a":"1"},"hsv":{"h":"183.63636363636363","s":"0.38372093023255816","v":"0.33725490196078434","a":"1"},"oldHue":"183.63636363636363","source":"hex","a":"1"},"textAlign":"left","fontStyle":"false","fontWeight":"400"},"classes":""},{"type":"text","content":"IS AWARDED","x":"0","y":"183","w":"900","h":"50","styles":{"fontSize":"32px","fontFamily":"Montserrat","color":{"hsl":{"h":"183.63636363636363","s":"0.23741007194244604","l":"0.27254901960784317","a":"1"},"hex":"#355456","rgba":{"r":"53","g":"84","b":"86","a":"1"},"hsv":{"h":"183.63636363636363","s":"0.38372093023255816","v":"0.33725490196078434","a":"1"},"oldHue":"183.63636363636363","source":"hex","a":"1"},"textAlign":"center","fontStyle":"false","fontWeight":"false"},"classes":""},{"type":"image","content":"' . $logo_urls['logo_blue'] . '","x":"330","y":"55","w":"239","h":"45","styles":{"fontSize":"14px","fontFamily":"OpenSans","color":{"hex":"#000"},"textAlign":"left","fontStyle":"normal","fontWeight":"400"},"classes":"right-align top-align","imageId":"5660"},{"type":"text","content":"Date","x":"223","y":"505","w":150,"h":26,"styles":{"fontSize":"14px","fontFamily":"OpenSans","color":{"hsl":{"h":"183.63636363636363","s":"0.23741007194244604","l":"0.27254901960784317","a":"1"},"hex":"#355456","rgba":{"r":"53","g":"84","b":"86","a":"1"},"hsv":{"h":"183.63636363636363","s":"0.38372093023255816","v":"0.33725490196078434","a":"1"},"oldHue":"183.63636363636363","source":"hex","a":"1"},"textAlign":"left","fontStyle":"false","fontWeight":"false"},"classes":""},{"type":"end_date","content":"-End Date-","x":263,"y":505,"w":177,"h":24,"styles":{"fontSize":"14px","fontFamily":"OpenSans","color":{"hsl":{"h":"183.63636363636363","s":"0.23741007194244604","l":"0.27254901960784317","a":"1"},"hex":"#355456","rgba":{"r":"53","g":"84","b":"86","a":"1"},"hsv":{"h":"183.63636363636363","s":"0.38372093023255816","v":"0.33725490196078434","a":"1"},"oldHue":"183.63636363636363","source":"hex","a":"1"},"textAlign":"left","fontStyle":"false","fontWeight":"true"},"classes":""},{"type":"text","content":"Certificate ID","x":451,"y":505,"w":150,"h":24,"styles":{"fontSize":"14px","fontFamily":"OpenSans","color":{"hsl":{"h":"183.63636363636363","s":"0.23741007194244604","l":"0.27254901960784317","a":"1"},"hex":"#355456","rgba":{"r":"53","g":"84","b":"86","a":"1"},"hsv":{"h":"183.63636363636363","s":"0.38372093023255816","v":"0.33725490196078434","a":"1"},"oldHue":"183.63636363636363","source":"hex","a":"1"},"textAlign":"left","fontStyle":"false","fontWeight":"false"},"classes":""}]',
			'demo-4'  => '[{"type":"text","content":"IS AWARDED","x":181,"y":118,"w":282,"h":50,"styles":{"fontSize":"28px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"left","fontStyle":false,"fontWeight":false},"classes":""},{"type":"text","content":"CERTIFICATE","x":181,"y":73,"w":262,"h":50,"styles":{"fontSize":"32px","fontFamily":"Montserrat","color":{"hsl":{"h":0,"s":0,"l":0.20000000000000001,"a":1},"hex":"#333333","rgba":{"r":51,"g":51,"b":51,"a":1},"hsv":{"h":0,"s":0,"v":0.20000000000000001,"a":1},"oldHue":0,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":"400"},"classes":"top-align"},{"type":"image","content":"' . $logo_urls['logo_brown'] . '","x":70,"y":70,"w":97,"h":94,"styles":{"fontSize":"14px","fontFamily":"OpenSans","color":{"hex":"#000"},"textAlign":"left","fontStyle":"normal","fontWeight":"400"},"classes":"top-align","imageId":5666},{"type":"student_name","content":"-Student name-","x":72,"y":207,"w":509,"h":32,"styles":{"fontSize":"20px","fontFamily":"Montserrat","color":{"hsl":{"h":0,"s":0,"l":0.20000000000000001,"a":1},"hex":"#333333","rgba":{"r":51,"g":51,"b":51,"a":1},"hsv":{"h":0,"s":0,"v":0.20000000000000001,"a":1},"oldHue":0,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"text","content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. In pharetra erat mi, sed rutrum nulla imperdiet eu. Suspendisse potenti. Mauris purus nisl, faucibus quis dolor sed, commodo commodo nulla. ","x":72,"y":262,"w":508,"h":60,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":0,"s":0,"l":0.20000000000000001,"a":1},"hex":"#333333","rgba":{"r":51,"g":51,"b":51,"a":1},"hsv":{"h":0,"s":0,"v":0.20000000000000001,"a":1},"oldHue":0,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":false},"classes":""},{"type":"course_name","content":"-Course name-","x":71,"y":343,"w":508,"h":34,"styles":{"fontSize":"20px","fontFamily":"Montserrat","color":{"hsl":{"h":0,"s":0,"l":0.20000000000000001,"a":1},"hex":"#333333","rgba":{"r":51,"g":51,"b":51,"a":1},"hsv":{"h":0,"s":0,"v":0.20000000000000001,"a":1},"oldHue":0,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"text","content":"Instructor","x":71,"y":395,"w":150,"h":29,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":0,"s":0,"l":0.20000000000000001,"a":1},"hex":"#333333","rgba":{"r":51,"g":51,"b":51,"a":1},"hsv":{"h":0,"s":0,"v":0.20000000000000001,"a":1},"oldHue":0,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":false},"classes":""},{"type":"author","content":"-Instructor-","x":71,"y":420,"w":483,"h":28,"styles":{"fontSize":"16px","fontFamily":"Montserrat","color":{"hsl":{"h":0,"s":0,"l":0.20000000000000001,"a":1},"hex":"#333333","rgba":{"r":51,"g":51,"b":51,"a":1},"hsv":{"h":0,"s":0,"v":0.20000000000000001,"a":1},"oldHue":0,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"text","content":"Signature","x":417,"y":437,"w":99,"h":25,"styles":{"fontSize":"12px","fontFamily":"Montserrat","color":{"hsl":{"h":0,"s":0,"l":0.20000000000000001,"a":1},"hex":"#333333","rgba":{"r":51,"g":51,"b":51,"a":1},"hsv":{"h":0,"s":0,"v":0.20000000000000001,"a":1},"oldHue":0,"source":"hex","a":1},"textAlign":"center","fontStyle":false,"fontWeight":false},"classes":""},{"type":"text","content":"Certificate ID","x":335,"y":504,"w":150,"h":26,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":0,"s":0,"l":0.20000000000000001,"a":1},"hex":"#333333","rgba":{"r":51,"g":51,"b":51,"a":1},"hsv":{"h":0,"s":0,"v":0.20000000000000001,"a":1},"oldHue":0,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":false},"classes":""},{"type":"text","content":"Date","x":70,"y":504,"w":150,"h":26,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":0,"s":0,"l":0.20000000000000001,"a":1},"hex":"#333333","rgba":{"r":51,"g":51,"b":51,"a":1},"hsv":{"h":0,"s":0,"v":0.20000000000000001,"a":1},"oldHue":0,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":false},"classes":""},{"type":"end_date","content":"-End Date-","x":113,"y":504,"w":218,"h":26,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":0,"s":0,"l":0.20000000000000001,"a":1},"hex":"#333333","rgba":{"r":51,"g":51,"b":51,"a":1},"hsv":{"h":0,"s":0,"v":0.20000000000000001,"a":1},"oldHue":0,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"code","content":"-Certificate code-","x":438,"y":504,"w":310,"h":26,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":0,"s":0,"l":0.20000000000000001,"a":1},"hex":"#333333","rgba":{"r":51,"g":51,"b":51,"a":1},"hsv":{"h":0,"s":0,"v":0.20000000000000001,"a":1},"oldHue":0,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"image","content":"' . $logo_urls['signature'] . '","x":338,"y":370,"w":193,"h":98,"styles":{"fontSize":"14px","fontFamily":"OpenSans","color":{"hex":"#000"},"textAlign":"left","fontStyle":"normal","fontWeight":"400"},"classes":"","imageId":5682}]',
			'demo-5'  => '[{"type":"image","content":"' . $logo_urls['logo_blue'] . '","x":339,"y":55,"w":219,"h":40,"styles":{"fontSize":"14px","fontFamily":"OpenSans","color":{"hex":"#000"},"textAlign":"left","fontStyle":"normal","fontWeight":"400"},"classes":"top-align","imageId":5660},{"type":"text","content":"IS AWARDED","x":0,"y":157,"w":900,"h":50,"styles":{"fontSize":"24px","fontFamily":"Montserrat","color":{"hsl":{"h":183.63636363636363,"s":0.23741007194244604,"l":0.27254901960784317,"a":1},"hex":"#355456","rgba":{"r":53,"g":84,"b":86,"a":1},"hsv":{"h":183.63636363636363,"s":0.38372093023255816,"v":0.33725490196078434,"a":1},"oldHue":183.63636363636363,"source":"hex","a":1},"textAlign":"center","fontStyle":false,"fontWeight":false},"classes":"left-align"},{"type":"text","content":"CERTIFICATE","x":0,"y":119,"w":900,"h":50,"styles":{"fontSize":"28px","fontFamily":"Montserrat","color":{"hsl":{"h":183.63636363636363,"s":0.23741007194244604,"l":0.27254901960784317,"a":1},"hex":"#355456","rgba":{"r":53,"g":84,"b":86,"a":1},"hsv":{"h":183.63636363636363,"s":0.38372093023255816,"v":0.33725490196078434,"a":1},"oldHue":183.63636363636363,"source":"hex","a":1},"textAlign":"center","fontStyle":false,"fontWeight":"400"},"classes":"left-align"},{"type":"text","content":"Instructor","x":102,"y":398,"w":150,"h":22,"styles":{"fontSize":"12px","fontFamily":"Montserrat","color":{"hsl":{"h":183.63636363636363,"s":0.23741007194244604,"l":0.27254901960784317,"a":1},"hex":"#355456","rgba":{"r":53,"g":84,"b":86,"a":1},"hsv":{"h":183.63636363636363,"s":0.38372093023255816,"v":0.33725490196078434,"a":1},"oldHue":183.63636363636363,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":false},"classes":""},{"type":"student_name","content":"-Student name-","x":0,"y":212,"w":900,"h":32,"styles":{"fontSize":"20px","fontFamily":"Montserrat","color":{"hsl":{"h":183.63636363636363,"s":0.23741007194244604,"l":0.27254901960784317,"a":1},"hex":"#355456","rgba":{"r":53,"g":84,"b":86,"a":1},"hsv":{"h":183.63636363636363,"s":0.38372093023255816,"v":0.33725490196078434,"a":1},"oldHue":183.63636363636363,"source":"hex","a":1},"textAlign":"center","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"text","content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. In pharetra erat mi, sed rutrum nulla imperdiet eu. Suspendisse potenti. Mauris purus nisl, faucibus quis dolor sed, commodo commodo nulla. ","x":242,"y":260,"w":423,"h":66,"styles":{"fontSize":"12px","fontFamily":"OpenSans","color":{"hsl":{"h":183.63636363636363,"s":0.23741007194244604,"l":0.27254901960784317,"a":1},"hex":"#355456","rgba":{"r":53,"g":84,"b":86,"a":1},"hsv":{"h":183.63636363636363,"s":0.38372093023255816,"v":0.33725490196078434,"a":1},"oldHue":183.63636363636363,"source":"hex","a":1},"textAlign":"center","fontStyle":false,"fontWeight":false},"classes":""},{"type":"course_name","content":"-Course name-","x":0,"y":344,"w":900,"h":31,"styles":{"fontSize":"20px","fontFamily":"Montserrat","color":{"hsl":{"h":183.63636363636363,"s":0.23741007194244604,"l":0.27254901960784317,"a":1},"hex":"#355456","rgba":{"r":53,"g":84,"b":86,"a":1},"hsv":{"h":183.63636363636363,"s":0.38372093023255816,"v":0.33725490196078434,"a":1},"oldHue":183.63636363636363,"source":"hex","a":1},"textAlign":"center","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"author","content":"-Instructor-","x":101,"y":424,"w":308,"h":33,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":183.63636363636363,"s":0.23741007194244604,"l":0.27254901960784317,"a":1},"hex":"#355456","rgba":{"r":53,"g":84,"b":86,"a":1},"hsv":{"h":183.63636363636363,"s":0.38372093023255816,"v":0.33725490196078434,"a":1},"oldHue":183.63636363636363,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":true},"classes":""},{"type":"text","content":"Date","x":104,"y":493,"w":81,"h":25,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":183.63636363636363,"s":0.23741007194244604,"l":0.27254901960784317,"a":1},"hex":"#355456","rgba":{"r":53,"g":84,"b":86,"a":1},"hsv":{"h":183.63636363636363,"s":0.38372093023255816,"v":0.33725490196078434,"a":1},"oldHue":183.63636363636363,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":false},"classes":""},{"type":"text","content":"Certificate ID","x":496,"y":493,"w":131,"h":24,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":183.63636363636363,"s":0.23741007194244604,"l":0.27254901960784317,"a":1},"hex":"#355456","rgba":{"r":53,"g":84,"b":86,"a":1},"hsv":{"h":183.63636363636363,"s":0.38372093023255816,"v":0.33725490196078434,"a":1},"oldHue":183.63636363636363,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":false},"classes":""},{"type":"code","content":"-Certificate code-","x":599,"y":493,"w":270,"h":24,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":183.63636363636363,"s":0.23741007194244604,"l":0.27254901960784317,"a":1},"hex":"#355456","rgba":{"r":53,"g":84,"b":86,"a":1},"hsv":{"h":183.63636363636363,"s":0.38372093023255816,"v":0.33725490196078434,"a":1},"oldHue":183.63636363636363,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"text","content":"Signature","x":543,"y":448,"w":150,"h":21,"styles":{"fontSize":"12px","fontFamily":"OpenSans","color":{"hsl":{"h":183.63636363636363,"s":0.23741007194244604,"l":0.27254901960784317,"a":1},"hex":"#355456","rgba":{"r":53,"g":84,"b":86,"a":1},"hsv":{"h":183.63636363636363,"s":0.38372093023255816,"v":0.33725490196078434,"a":1},"oldHue":183.63636363636363,"source":"hex","a":1},"textAlign":"center","fontStyle":false,"fontWeight":false},"classes":""},{"type":"image","content":"' . $logo_urls['signature'] . '","x":505,"y":368,"w":181,"h":113,"styles":{"fontSize":"14px","fontFamily":"OpenSans","color":{"hex":"#000"},"textAlign":"left","fontStyle":"normal","fontWeight":"400"},"classes":"","imageId":5682},{"type":"end_date","content":"-End Date-","x":147,"y":493,"w":150,"h":25,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":183.63636363636363,"s":0.23741007194244604,"l":0.27254901960784317,"a":1},"hex":"#355456","rgba":{"r":53,"g":84,"b":86,"a":1},"hsv":{"h":183.63636363636363,"s":0.38372093023255816,"v":0.33725490196078434,"a":1},"oldHue":183.63636363636363,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":true},"classes":""}]',
			'demo-6'  => '[{"type":"image","content":"' . $logo_urls['logo_brown_full'] . '","x":45,"y":18,"w":218,"h":40,"styles":{"fontSize":"14px","fontFamily":"OpenSans","color":{"hex":"#000"},"textAlign":"left","fontStyle":"normal","fontWeight":"400"},"classes":"left-align top-align","imageId":5670},{"type":"text","content":"CERTIFICATE","x":230,"y":140,"w":248,"h":43,"styles":{"fontSize":"28px","fontFamily":"Montserrat","color":{"hsl":{"h":238.57142857142856,"s":0.32812499999999994,"l":0.25098039215686274,"a":1},"hex":"#2B2C55","rgba":{"r":43,"g":44,"b":85,"a":1},"hsv":{"h":238.57142857142856,"s":0.49411764705882344,"v":0.33333333333333331,"a":1},"oldHue":238.57142857142856,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"text","content":"IS AWARDED","x":229,"y":179,"w":214,"h":39,"styles":{"fontSize":"24px","fontFamily":"Montserrat","color":{"hsl":{"h":238.57142857142856,"s":0.32812499999999994,"l":0.25098039215686274,"a":1},"hex":"#2B2C55","rgba":{"r":43,"g":44,"b":85,"a":1},"hsv":{"h":238.57142857142856,"s":0.49411764705882344,"v":0.33333333333333331,"a":1},"oldHue":238.57142857142856,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":false},"classes":""},{"type":"student_name","content":"-Student name-","x":230,"y":233,"w":226,"h":33,"styles":{"fontSize":"20px","fontFamily":"Montserrat","color":{"hsl":{"h":238.57142857142856,"s":0.32812499999999994,"l":0.25098039215686274,"a":1},"hex":"#2B2C55","rgba":{"r":43,"g":44,"b":85,"a":1},"hsv":{"h":238.57142857142856,"s":0.49411764705882344,"v":0.33333333333333331,"a":1},"oldHue":238.57142857142856,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"text","content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. In pharetra erat mi, sed rutrum nulla imperdiet eu. Suspendisse potenti. Mauris purus nisl, faucibus quis dolor sed, commodo commodo nulla. ","x":230,"y":283,"w":487,"h":79,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":238.57142857142856,"s":0.32812499999999994,"l":0.25098039215686274,"a":1},"hex":"#2B2C55","rgba":{"r":43,"g":44,"b":85,"a":1},"hsv":{"h":238.57142857142856,"s":0.49411764705882344,"v":0.33333333333333331,"a":1},"oldHue":238.57142857142856,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":false},"classes":""},{"type":"course_name","content":"-Course name-","x":230,"y":365,"w":483,"h":30,"styles":{"fontSize":"18px","fontFamily":"OpenSans","color":{"hsl":{"h":238.57142857142856,"s":0.32812499999999994,"l":0.25098039215686274,"a":1},"hex":"#2B2C55","rgba":{"r":43,"g":44,"b":85,"a":1},"hsv":{"h":238.57142857142856,"s":0.49411764705882344,"v":0.33333333333333331,"a":1},"oldHue":238.57142857142856,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"text","content":"Instructor","x":229,"y":411,"w":150,"h":24,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":238.57142857142856,"s":0.32812499999999994,"l":0.25098039215686274,"a":1},"hex":"#2B2C55","rgba":{"r":43,"g":44,"b":85,"a":1},"hsv":{"h":238.57142857142856,"s":0.49411764705882344,"v":0.33333333333333331,"a":1},"oldHue":238.57142857142856,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":false},"classes":""},{"type":"author","content":"-Instructor-","x":229,"y":432,"w":485,"h":27,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":238.57142857142856,"s":0.32812499999999994,"l":0.25098039215686274,"a":1},"hex":"#2B2C55","rgba":{"r":43,"g":44,"b":85,"a":1},"hsv":{"h":238.57142857142856,"s":0.49411764705882344,"v":0.33333333333333331,"a":1},"oldHue":238.57142857142856,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"text","content":"Date","x":230,"y":468,"w":150,"h":27,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":238.57142857142856,"s":0.32812499999999994,"l":0.25098039215686274,"a":1},"hex":"#2B2C55","rgba":{"r":43,"g":44,"b":85,"a":1},"hsv":{"h":238.57142857142856,"s":0.49411764705882344,"v":0.33333333333333331,"a":1},"oldHue":238.57142857142856,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":false},"classes":""},{"type":"end_date","content":"-End Date-","x":271,"y":468,"w":191,"h":27,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":238.57142857142856,"s":0.32812499999999994,"l":0.25098039215686274,"a":1},"hex":"#2B2C55","rgba":{"r":43,"g":44,"b":85,"a":1},"hsv":{"h":238.57142857142856,"s":0.49411764705882344,"v":0.33333333333333331,"a":1},"oldHue":238.57142857142856,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":true},"classes":""},{"type":"text","content":"Certificate ID","x":465,"y":468,"w":150,"h":28,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":238.57142857142856,"s":0.32812499999999994,"l":0.25098039215686274,"a":1},"hex":"#2B2C55","rgba":{"r":43,"g":44,"b":85,"a":1},"hsv":{"h":238.57142857142856,"s":0.49411764705882344,"v":0.33333333333333331,"a":1},"oldHue":238.57142857142856,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":false},"classes":""},{"type":"code","content":"-Certificate code-","x":567,"y":468,"w":263,"h":28,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":238.57142857142856,"s":0.32812499999999994,"l":0.25098039215686274,"a":1},"hex":"#2B2C55","rgba":{"r":43,"g":44,"b":85,"a":1},"hsv":{"h":238.57142857142856,"s":0.49411764705882344,"v":0.33333333333333331,"a":1},"oldHue":238.57142857142856,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"image","content":"' . $logo_urls['signature'] . '","x":566,"y":374,"w":120,"h":98,"styles":{"fontSize":"14px","fontFamily":"OpenSans","color":{"hex":"#000"},"textAlign":"left","fontStyle":"normal","fontWeight":"400"},"classes":"","imageId":5682}]',
			'demo-7'  => '[{"type":"image","content":"' . $logo_urls['logo_orange'] . '","x":332,"y":85,"w":226,"h":42,"styles":{"fontSize":"14px","fontFamily":"OpenSans","color":{"hex":"#000"},"textAlign":"left","fontStyle":"normal","fontWeight":"400"},"classes":"top-align","imageId":5673},{"type":"text","content":"CERTIFICATE","x":0,"y":141,"w":898,"h":57,"styles":{"fontSize":"40px","fontFamily":"Montserrat","color":{"hsl":{"h":12.463768115942029,"s":0.92825112107623331,"l":0.56274509803921569,"a":1},"hex":"#F75328","rgba":{"r":247,"g":83,"b":40,"a":1},"hsv":{"h":12.463768115942029,"s":0.83805668016194335,"v":0.96862745098039216,"a":1},"oldHue":12.463768115942029,"source":"hex","a":1},"textAlign":"center","fontStyle":false,"fontWeight":"400"},"classes":"left-align"},{"type":"text","content":"IS AWARDED","x":0,"y":189,"w":900,"h":50,"styles":{"fontSize":"28px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"center","fontStyle":false,"fontWeight":false},"classes":"left-align"},{"type":"student_name","content":"-Student name-","x":0,"y":240,"w":898,"h":42,"styles":{"fontSize":"28px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"center","fontStyle":false,"fontWeight":true},"classes":"left-align"},{"type":"text","content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. In pharetra erat mi, sed rutrum nulla imperdiet eu. Suspendisse potenti. Mauris purus nisl, faucibus quis dolor sed, commodo commodo nulla. ","x":170,"y":298,"w":551,"h":68,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"center","fontStyle":false,"fontWeight":false},"classes":""},{"type":"course_name","content":"-Course name-","x":0,"y":362,"w":898,"h":41,"styles":{"fontSize":"28px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"center","fontStyle":false,"fontWeight":"400"},"classes":"left-align"},{"type":"text","content":"Instructor","x":231,"y":417,"w":150,"h":25,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"left","fontStyle":false,"fontWeight":false},"classes":""},{"type":"author","content":"-Instructor-","x":232,"y":436,"w":492,"h":27,"styles":{"fontSize":"16px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"left","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"text","content":"Date","x":232,"y":487,"w":150,"h":26,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"left","fontStyle":false,"fontWeight":false},"classes":""},{"type":"end_date","content":"-End Date-","x":277,"y":487,"w":213,"h":26,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"left","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"text","content":"Certificate ID","x":460,"y":487,"w":150,"h":30,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"left","fontStyle":false,"fontWeight":false},"classes":""},{"type":"code","content":"-Certificate code-","x":569,"y":487,"w":266,"h":30,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hex":"#000"},"textAlign":"left","fontStyle":false,"fontWeight":true},"classes":""},{"type":"image","content":"' . $logo_urls['signature'] . '","x":519,"y":389,"w":154,"h":99,"styles":{"fontSize":"14px","fontFamily":"OpenSans","color":{"hex":"#000"},"textAlign":"left","fontStyle":"normal","fontWeight":"400"},"classes":"","imageId":5682}]',
			'demo-8'  => '[{"type":"text","content":"CERTIFICATE","x":0,"y":141,"w":900,"h":57,"styles":{"fontSize":"40px","fontFamily":"Katibeh","color":{"hsl":{"h":216,"s":0.41353383458646614,"l":0.26078431372549021,"a":1},"hex":"#273D5E","rgba":{"r":39,"g":61,"b":94,"a":1},"hsv":{"h":216,"s":0.58510638297872342,"v":0.36862745098039218,"a":1},"oldHue":216,"source":"hex","a":1},"textAlign":"center","fontStyle":false,"fontWeight":"400"},"classes":"left-align"},{"type":"image","content":"' . $logo_urls['logo_navy'] . '","x":344,"y":82,"w":207,"h":39,"styles":{"fontSize":"14px","fontFamily":"OpenSans","color":{"hex":"#000"},"textAlign":"left","fontStyle":"normal","fontWeight":"400"},"classes":"top-align","imageId":5675},{"type":"text","content":"IS AWARDED","x":0,"y":176,"w":900,"h":50,"styles":{"fontSize":"32px","fontFamily":"Katibeh","color":{"hsl":{"h":216,"s":0.41353383458646614,"l":0.26078431372549021,"a":1},"hex":"#273D5E","rgba":{"r":39,"g":61,"b":94,"a":1},"hsv":{"h":216,"s":0.58510638297872342,"v":0.36862745098039218,"a":1},"oldHue":216,"source":"hex","a":1},"textAlign":"center","fontStyle":false,"fontWeight":false},"classes":"left-align"},{"type":"student_name","content":"-Student name-","x":0,"y":227,"w":900,"h":50,"styles":{"fontSize":"32px","fontFamily":"Katibeh","color":{"hsl":{"h":216,"s":0.41353383458646614,"l":0.26078431372549021,"a":1},"hex":"#273D5E","rgba":{"r":39,"g":61,"b":94,"a":1},"hsv":{"h":216,"s":0.58510638297872342,"v":0.36862745098039218,"a":1},"oldHue":216,"source":"hex","a":1},"textAlign":"center","fontStyle":false,"fontWeight":"400"},"classes":"left-align"},{"type":"text","content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. In pharetra erat mi, sed rutrum nulla imperdiet eu. Suspendisse potenti. Mauris purus nisl, faucibus quis dolor sed, commodo commodo nulla. ","x":227,"y":280,"w":456,"h":89,"styles":{"fontSize":"18px","fontFamily":"Katibeh","color":{"hsl":{"h":216,"s":0.41353383458646614,"l":0.26078431372549021,"a":1},"hex":"#273D5E","rgba":{"r":39,"g":61,"b":94,"a":1},"hsv":{"h":216,"s":0.58510638297872342,"v":0.36862745098039218,"a":1},"oldHue":216,"source":"hex","a":1},"textAlign":"center","fontStyle":false,"fontWeight":false},"classes":""},{"type":"course_name","content":"-Course name-","x":0,"y":368,"w":900,"h":41,"styles":{"fontSize":"28px","fontFamily":"Katibeh","color":{"hsl":{"h":216,"s":0.41353383458646614,"l":0.26078431372549021,"a":1},"hex":"#273D5E","rgba":{"r":39,"g":61,"b":94,"a":1},"hsv":{"h":216,"s":0.58510638297872342,"v":0.36862745098039218,"a":1},"oldHue":216,"source":"hex","a":1},"textAlign":"center","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"text","content":"Instructor","x":196,"y":416,"w":150,"h":50,"styles":{"fontSize":"20px","fontFamily":"Katibeh","color":{"hsl":{"h":216,"s":0.41353383458646614,"l":0.26078431372549021,"a":1},"hex":"#273D5E","rgba":{"r":39,"g":61,"b":94,"a":1},"hsv":{"h":216,"s":0.58510638297872342,"v":0.36862745098039218,"a":1},"oldHue":216,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":true},"classes":""},{"type":"author","content":"-Instructor-","x":194,"y":436,"w":493,"h":41,"styles":{"fontSize":"24px","fontFamily":"Katibeh","color":{"hsl":{"h":216,"s":0.41353383458646614,"l":0.26078431372549021,"a":1},"hex":"#273D5E","rgba":{"r":39,"g":61,"b":94,"a":1},"hsv":{"h":216,"s":0.58510638297872342,"v":0.36862745098039218,"a":1},"oldHue":216,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":true},"classes":""},{"type":"text","content":"Date","x":194,"y":491,"w":150,"h":31,"styles":{"fontSize":"20px","fontFamily":"Katibeh","color":{"hsl":{"h":216,"s":0.41353383458646614,"l":0.26078431372549021,"a":1},"hex":"#273D5E","rgba":{"r":39,"g":61,"b":94,"a":1},"hsv":{"h":216,"s":0.58510638297872342,"v":0.36862745098039218,"a":1},"oldHue":216,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"text","content":"Certificate ID","x":417,"y":491,"w":150,"h":34,"styles":{"fontSize":"20px","fontFamily":"Katibeh","color":{"hsl":{"h":216,"s":0.41353383458646614,"l":0.26078431372549021,"a":1},"hex":"#273D5E","rgba":{"r":39,"g":61,"b":94,"a":1},"hsv":{"h":216,"s":0.58510638297872342,"v":0.36862745098039218,"a":1},"oldHue":216,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"code","content":"-Certificate code-","x":513,"y":490,"w":298,"h":33,"styles":{"fontSize":"20px","fontFamily":"Katibeh","color":{"hsl":{"h":216,"s":0.41353383458646614,"l":0.26078431372549021,"a":1},"hex":"#273D5E","rgba":{"r":39,"g":61,"b":94,"a":1},"hsv":{"h":216,"s":0.58510638297872342,"v":0.36862745098039218,"a":1},"oldHue":216,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"end_date","content":"-End Date-","x":234,"y":491,"w":185,"h":33,"styles":{"fontSize":"20px","fontFamily":"Katibeh","color":{"hsl":{"h":216,"s":0.41353383458646614,"l":0.26078431372549021,"a":1},"hex":"#273D5E","rgba":{"r":39,"g":61,"b":94,"a":1},"hsv":{"h":216,"s":0.58510638297872342,"v":0.36862745098039218,"a":1},"oldHue":216,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"image","content":"' . $logo_urls['signature'] . '","x":519,"y":404,"w":119,"h":78,"styles":{"fontSize":"14px","fontFamily":"OpenSans","color":{"hex":"#000"},"textAlign":"left","fontStyle":"normal","fontWeight":"400"},"classes":"","imageId":5682}]',
			'demo-9'  => '[{"type":"image","content":"' . $logo_urls['logo_navy'] . '","x":328,"y":41,"w":237,"h":44,"styles":{"fontSize":"14px","fontFamily":"OpenSans","color":{"hex":"#000"},"textAlign":"left","fontStyle":"normal","fontWeight":"400"},"classes":"top-align","imageId":5675},{"type":"text","content":"CERTIFICATE","x":0,"y":115,"w":900,"h":67,"styles":{"fontSize":"40px","fontFamily":"Oswald","color":{"hsl":{"h":216,"s":0.41353383458646614,"l":0.26078431372549021,"a":1},"hex":"#273D5E","rgba":{"r":39,"g":61,"b":94,"a":1},"hsv":{"h":216,"s":0.58510638297872342,"v":0.36862745098039218,"a":1},"oldHue":216,"source":"hex","a":1},"textAlign":"center","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"text","content":"IS AWARDED","x":0,"y":165,"w":900,"h":50,"styles":{"fontSize":"32px","fontFamily":"Oswald","color":{"hsl":{"h":216,"s":0.41353383458646614,"l":0.26078431372549021,"a":1},"hex":"#273D5E","rgba":{"r":39,"g":61,"b":94,"a":1},"hsv":{"h":216,"s":0.58510638297872342,"v":0.36862745098039218,"a":1},"oldHue":216,"source":"hex","a":1},"textAlign":"center","fontStyle":false,"fontWeight":false},"classes":"left-align"},{"type":"student_name","content":"-Student name-","x":0,"y":225,"w":900,"h":50,"styles":{"fontSize":"28px","fontFamily":"Oswald","color":{"hsl":{"h":216,"s":0.41353383458646614,"l":0.26078431372549021,"a":1},"hex":"#273D5E","rgba":{"r":39,"g":61,"b":94,"a":1},"hsv":{"h":216,"s":0.58510638297872342,"v":0.36862745098039218,"a":1},"oldHue":216,"source":"hex","a":1},"textAlign":"center","fontStyle":false,"fontWeight":"400"},"classes":"left-align"},{"type":"text","content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. In pharetra erat mi, sed rutrum nulla imperdiet eu. Suspendisse potenti. Mauris purus nisl, faucibus quis dolor sed, commodo commodo nulla. ","x":130,"y":278,"w":639,"h":73,"styles":{"fontSize":"14px","fontFamily":"Oswald","color":{"hsl":{"h":216,"s":0.41353383458646614,"l":0.26078431372549021,"a":1},"hex":"#273D5E","rgba":{"r":39,"g":61,"b":94,"a":1},"hsv":{"h":216,"s":0.58510638297872342,"v":0.36862745098039218,"a":1},"oldHue":216,"source":"hex","a":1},"textAlign":"center","fontStyle":false,"fontWeight":false},"classes":""},{"type":"course_name","content":"-Course name-","x":0,"y":358,"w":900,"h":50,"styles":{"fontSize":"24px","fontFamily":"Oswald","color":{"hsl":{"h":216,"s":0.41353383458646614,"l":0.26078431372549021,"a":1},"hex":"#273D5E","rgba":{"r":39,"g":61,"b":94,"a":1},"hsv":{"h":216,"s":0.58510638297872342,"v":0.36862745098039218,"a":1},"oldHue":216,"source":"hex","a":1},"textAlign":"center","fontStyle":false,"fontWeight":"400"},"classes":"left-align"},{"type":"text","content":"Instructor","x":200,"y":421,"w":150,"h":50,"styles":{"fontSize":"14px","fontFamily":"Oswald","color":{"hsl":{"h":216,"s":0.41353383458646614,"l":0.26078431372549021,"a":1},"hex":"#273D5E","rgba":{"r":39,"g":61,"b":94,"a":1},"hsv":{"h":216,"s":0.58510638297872342,"v":0.36862745098039218,"a":1},"oldHue":216,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":false},"classes":""},{"type":"author","content":"-Instructor-","x":199,"y":442,"w":513,"h":30,"styles":{"fontSize":"18px","fontFamily":"Oswald","color":{"hsl":{"h":216,"s":0.41353383458646614,"l":0.26078431372549021,"a":1},"hex":"#273D5E","rgba":{"r":39,"g":61,"b":94,"a":1},"hsv":{"h":216,"s":0.58510638297872342,"v":0.36862745098039218,"a":1},"oldHue":216,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"text","content":"Date","x":199,"y":501,"w":150,"h":28,"styles":{"fontSize":"14px","fontFamily":"Oswald","color":{"hsl":{"h":216,"s":0.41353383458646614,"l":0.26078431372549021,"a":1},"hex":"#273D5E","rgba":{"r":39,"g":61,"b":94,"a":1},"hsv":{"h":216,"s":0.58510638297872342,"v":0.36862745098039218,"a":1},"oldHue":216,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":false},"classes":""},{"type":"end_date","content":"-End Date-","x":230,"y":501,"w":251,"h":30,"styles":{"fontSize":"14px","fontFamily":"Oswald","color":{"hsl":{"h":216,"s":0.41353383458646614,"l":0.26078431372549021,"a":1},"hex":"#273D5E","rgba":{"r":39,"g":61,"b":94,"a":1},"hsv":{"h":216,"s":0.58510638297872342,"v":0.36862745098039218,"a":1},"oldHue":216,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"text","content":"Certificate ID","x":482,"y":501,"w":150,"h":31,"styles":{"fontSize":"14px","fontFamily":"Oswald","color":{"hsl":{"h":216,"s":0.41353383458646614,"l":0.26078431372549021,"a":1},"hex":"#273D5E","rgba":{"r":39,"g":61,"b":94,"a":1},"hsv":{"h":216,"s":0.58510638297872342,"v":0.36862745098039218,"a":1},"oldHue":216,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":false},"classes":""},{"type":"code","content":"-Certificate code-","x":560,"y":501,"w":329,"h":32,"styles":{"fontSize":"14px","fontFamily":"Oswald","color":{"hsl":{"h":216,"s":0.41353383458646614,"l":0.26078431372549021,"a":1},"hex":"#273D5E","rgba":{"r":39,"g":61,"b":94,"a":1},"hsv":{"h":216,"s":0.58510638297872342,"v":0.36862745098039218,"a":1},"oldHue":216,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":true},"classes":""},{"type":"image","content":"' . $logo_urls['sign'] . '","x":569,"y":401,"w":109,"h":87,"styles":{"fontSize":"14px","fontFamily":"OpenSans","color":{"hex":"#000"},"textAlign":"left","fontStyle":"normal","fontWeight":"400"},"classes":"","imageId":5527}]',
			'demo-10' => '[{"type":"text","content":"CERTIFICATE","x":47,"y":203,"w":242,"h":48,"styles":{"fontSize":"28px","fontFamily":"Montserrat","color":{"hsl":{"h":238.57142857142856,"s":0.32812499999999994,"l":0.25098039215686274,"a":1},"hex":"#2B2C55","rgba":{"r":43,"g":44,"b":85,"a":1},"hsv":{"h":238.57142857142856,"s":0.49411764705882344,"v":0.33333333333333331,"a":1},"oldHue":238.57142857142856,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":"400"},"classes":"left-align"},{"type":"text","content":"IS AWARDED","x":47,"y":245,"w":245,"h":50,"styles":{"fontSize":"28px","fontFamily":"Montserrat","color":{"hsl":{"h":238.57142857142856,"s":0.32812499999999994,"l":0.25098039215686274,"a":1},"hex":"#2B2C55","rgba":{"r":43,"g":44,"b":85,"a":1},"hsv":{"h":238.57142857142856,"s":0.49411764705882344,"v":0.33333333333333331,"a":1},"oldHue":238.57142857142856,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":false},"classes":"left-align"},{"type":"text","content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. In pharetra erat mi, sed rutrum nulla imperdiet eu. Suspendisse potenti. Mauris purus nisl, faucibus quis dolor sed, commodo commodo nulla. ","x":50,"y":396,"w":501,"h":74,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":238.57142857142856,"s":0.32812499999999994,"l":0.25098039215686274,"a":1},"hex":"#2B2C55","rgba":{"r":43,"g":44,"b":85,"a":1},"hsv":{"h":238.57142857142856,"s":0.49411764705882344,"v":0.33333333333333331,"a":1},"oldHue":238.57142857142856,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":false},"classes":""},{"type":"image","content":"' . $logo_urls['logo_navy'] . '","x":46,"y":123,"w":203,"h":37,"styles":{"fontSize":"14px","fontFamily":"OpenSans","color":{"hex":"#000"},"textAlign":"left","fontStyle":"normal","fontWeight":"400"},"classes":"left-align","imageId":5675},{"type":"student_name","content":"-Student name-","x":50,"y":325,"w":502,"h":44,"styles":{"fontSize":"24px","fontFamily":"Montserrat","color":{"hsl":{"h":238.57142857142856,"s":0.32812499999999994,"l":0.25098039215686274,"a":1},"hex":"#2B2C55","rgba":{"r":43,"g":44,"b":85,"a":1},"hsv":{"h":238.57142857142856,"s":0.49411764705882344,"v":0.33333333333333331,"a":1},"oldHue":238.57142857142856,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"course_name","content":"-Course name-","x":50,"y":485,"w":502,"h":50,"styles":{"fontSize":"20px","fontFamily":"Montserrat","color":{"hsl":{"h":238.57142857142856,"s":0.32812499999999994,"l":0.25098039215686274,"a":1},"hex":"#2B2C55","rgba":{"r":43,"g":44,"b":85,"a":1},"hsv":{"h":238.57142857142856,"s":0.49411764705882344,"v":0.33333333333333331,"a":1},"oldHue":238.57142857142856,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"text","content":"Instructor","x":51,"y":593,"w":150,"h":50,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":238.57142857142856,"s":0.32812499999999994,"l":0.25098039215686274,"a":1},"hex":"#2B2C55","rgba":{"r":43,"g":44,"b":85,"a":1},"hsv":{"h":238.57142857142856,"s":0.49411764705882344,"v":0.33333333333333331,"a":1},"oldHue":238.57142857142856,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":false},"classes":""},{"type":"author","content":"-Instructor-","x":51,"y":616,"w":507,"h":27,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":238.57142857142856,"s":0.32812499999999994,"l":0.25098039215686274,"a":1},"hex":"#2B2C55","rgba":{"r":43,"g":44,"b":85,"a":1},"hsv":{"h":238.57142857142856,"s":0.49411764705882344,"v":0.33333333333333331,"a":1},"oldHue":238.57142857142856,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"text","content":"Certificate ID","x":278,"y":693,"w":150,"h":27,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":238.57142857142856,"s":0.32812499999999994,"l":0.25098039215686274,"a":1},"hex":"#2B2C55","rgba":{"r":43,"g":44,"b":85,"a":1},"hsv":{"h":238.57142857142856,"s":0.49411764705882344,"v":0.33333333333333331,"a":1},"oldHue":238.57142857142856,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":false},"classes":""},{"type":"text","content":"Date","x":53,"y":693,"w":150,"h":25,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":238.57142857142856,"s":0.32812499999999994,"l":0.25098039215686274,"a":1},"hex":"#2B2C55","rgba":{"r":43,"g":44,"b":85,"a":1},"hsv":{"h":238.57142857142856,"s":0.49411764705882344,"v":0.33333333333333331,"a":1},"oldHue":238.57142857142856,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":false},"classes":""},{"type":"end_date","content":"-End Date-","x":53,"y":716,"w":195,"h":27,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":238.57142857142856,"s":0.32812499999999994,"l":0.25098039215686274,"a":1},"hex":"#2B2C55","rgba":{"r":43,"g":44,"b":85,"a":1},"hsv":{"h":238.57142857142856,"s":0.49411764705882344,"v":0.33333333333333331,"a":1},"oldHue":238.57142857142856,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":true},"classes":""},{"type":"code","content":"-Certificate code-","x":278,"y":716,"w":297,"h":26,"styles":{"fontSize":"14px","fontFamily":"Montserrat","color":{"hsl":{"h":238.57142857142856,"s":0.32812499999999994,"l":0.25098039215686274,"a":1},"hex":"#2B2C55","rgba":{"r":43,"g":44,"b":85,"a":1},"hsv":{"h":238.57142857142856,"s":0.49411764705882344,"v":0.33333333333333331,"a":1},"oldHue":238.57142857142856,"source":"hex","a":1},"textAlign":"left","fontStyle":false,"fontWeight":"400"},"classes":""},{"type":"image","content":"' . $logo_urls['sign'] . '","x":396,"y":554,"w":109,"h":98,"styles":{"fontSize":"14px","fontFamily":"OpenSans","color":{"hex":"#000"},"textAlign":"left","fontStyle":"normal","fontWeight":"400"},"classes":"right-align","imageId":5523}]',
		);

		foreach ( self::DEMOS as $demo_key => $demo ) {
			if ( in_array( $demo_key, $exclude_demos, true ) ) {
				continue;
			}

			$demo['fields']       = $demo_fields[ $demo_key ];
			$demo['thumbnail_id'] = $this->upload_image( STM_LMS_PRO_PATH . $demo['thumbnail'] );

			unset( $demo['thumbnail'] );

			$certificate_ids[] = $repository->create( wp_slash( $demo ) );
		}

		return $certificate_ids;
	}

	protected function upload_logos() {
		$images = array(
			'logo_gray'       => STM_LMS_PRO_PATH . '/assets/img/certificate-builder/logo.png',
			'logo_blue'       => STM_LMS_PRO_PATH . '/assets/img/certificate-builder/logo-blue.png',
			'logo_navy'       => STM_LMS_PRO_PATH . '/assets/img/certificate-builder/logo-navy.png',
			'logo_brown'      => STM_LMS_PRO_PATH . '/assets/img/certificate-builder/logo-brown.png',
			'logo_brown_full' => STM_LMS_PRO_PATH . '/assets/img/certificate-builder/logo-brown-full.png',
			'logo_orange'     => STM_LMS_PRO_PATH . '/assets/img/certificate-builder/logo-orange.png',
			'sign'            => STM_LMS_PRO_PATH . '/assets/img/certificate-builder/sign.png',
			'signature'       => STM_LMS_PRO_PATH . '/assets/img/certificate-builder/signature.png',
		);

		$image_ids = array_combine(
			array_keys( $images ),
			array_map(
				function( $path ) {
					return $this->upload_image( $path );
				},
				$images
			)
		);

		return array_combine(
			array_keys( $image_ids ),
			array_map( 'wp_get_attachment_url', $image_ids )
		);
	}

	protected function upload_image( $path = '' ): int {
		global $wp_filesystem;

		if ( empty( $wp_filesystem ) ) {
			require_once ABSPATH . '/wp-admin/includes/file.php';
			WP_Filesystem();
		}

		$upload_dir = wp_upload_dir();
		$image_data = $wp_filesystem->get_contents( $path );
		$filename   = basename( $path );

		if ( wp_mkdir_p( $upload_dir['path'] ) ) {
			$file = $upload_dir['path'] . '/' . $filename;
		} else {
			$file = $upload_dir['basedir'] . '/' . $filename;
		}

		$wp_filesystem->put_contents( $file, $image_data, FS_CHMOD_FILE );

		$wp_filetype = wp_check_filetype( $filename, null );

		$attachment = array(
			'post_mime_type' => $wp_filetype['type'],
			'post_title'     => sanitize_file_name( $filename ),
			'post_content'   => '',
			'post_status'    => 'inherit',
		);

		$attach_id = wp_insert_attachment( $attachment, $file );

		if ( is_wp_error( $attach_id ) ) {
			return 0;
		}

		require_once ABSPATH . 'wp-admin/includes/image.php';

		$attach_data = wp_generate_attachment_metadata( $attach_id, $file );

		wp_update_attachment_metadata( $attach_id, $attach_data );

		return $attach_id;
	}
}
