<?php if ( ! defined( 'ABSPATH' ) ) {
	exit;
} //Exit if accessed directly ?>

<?php
STM_LMS_Templates::show_lms_template( 'header' );
stm_lms_register_style( 'gradebook' );
stm_lms_register_script( 'gradebook' );
do_action( 'stm_lms_template_main' );
$style = STM_LMS_Options::get_option( 'profile_style', 'default' );

$course_details_template  = STM_LMS_Templates::load_lms_template( 'gradebook/course-details' );
$student_details_template = STM_LMS_Templates::load_lms_template( 'gradebook/students-details' );

wp_localize_script(
	'stm-lms-gradebook',
	'gradebook_data',
	array(
		'course_html'  => array(
			'course_details_template'  => $course_details_template,
			'student_details_template' => $student_details_template,
		),
		'translations' => array(
			'more_info'          => esc_html__( 'More info', 'masterstudy-lms-learning-management-system-pro' ),
			'show_less'          => esc_html__( 'Show less', 'masterstudy-lms-learning-management-system-pro' ),
			'lessons_passed'     => esc_html__( 'Lessons Passed', 'masterstudy-lms-learning-management-system-pro' ),
			'quizzes_passed'     => esc_html__( 'Quizzes Passed', 'masterstudy-lms-learning-management-system-pro' ),
			'quizzes_failed'     => esc_html__( 'Quizzes Failed', 'masterstudy-lms-learning-management-system-pro' ),
			'assignments_passed' => esc_html__( 'Assignments Passed', 'masterstudy-lms-learning-management-system-pro' ),
			'progress'           => esc_html__( 'Progress', 'masterstudy-lms-learning-management-system-pro' ),
			'started'            => esc_html__( 'Started', 'masterstudy-lms-learning-management-system-pro' ),
		),
	)
)
?>

<?php STM_LMS_Templates::show_lms_template( 'modals/preloader' ); ?>

<div class="stm-lms-wrapper stm-lms-wrapper--gradebook user-account-page">
	<div class="container">
		<div id="stm_lms_gradebook">
			<?php do_action( 'stm_lms_admin_after_wrapper_start', STM_LMS_User::get_current_user() ); ?>

			<div class="gradebook-header">
				<h1><?php esc_html_e( 'The Gradebook', 'masterstudy-lms-learning-management-system-pro' ); ?></h1>

				<div class="stm_lms_gradebook__filter">
					<div class="form-group">
						<label class="heading_font"><?php esc_html_e( 'Search Courses', 'masterstudy-lms-learning-management-system-pro' ); ?></label>
						<input type="text" class="form-control stm_lms_gradebook__search-input" placeholder="<?php esc_html_e( 'Enter keyword here', 'masterstudy-lms-learning-management-system-pro' ); ?>"/>
					</div>
				</div>
			</div>

			<div class="multiseparator"></div>

			<div class="stm_lms_gradebook__courses">
			</div>

			<a href="#" class="btn btn-default gradebook-load-btn hidden">
				<?php esc_html_e( 'Load more', 'masterstudy-lms-learning-management-system-pro' ); ?>
			</a>
		</div>
	</div>
</div>

<?php
	STM_LMS_Templates::show_lms_template( 'footer' );
